//Psudo random coal load/ballast block creator
//Based on code from RMWEB by TangoOscarMike
//Enhanced option generator written by Les Coombes
//
//Licensed under CC BY-NC-SA 4.0
//https://creativecommons.org/licenses/by-nc-sa/4.0/
//
// 8/1/2024     V3
// 10/1/2024    V4  Added trim option to allow ragged edges
//                  Changed way base created - follows profile
// 12/1/2024    V5  Updated taper generation 
//                  Changed customiser settings - added limits
// 14/1/2024    V6  Updated internal fill for negative coal heights
// 19/1/2024      d Updated taper generation - radius
// 20/1/2024      e Varius tweeks
// 21/1/2024       4 Changed pillar top profile
// 22/1/2024       5 Added track slot option
// 28/1/2024    V7  Added fill type profiling
//
echo("Enhanced coal load/ballast block creator");
echo("Licence CC BY-NC-SA 4.0");
echo("Version - V17a Development");


//Coal profiling parameters
/* [Coal Profiling:] */
coal_size = 4.0;    //[3:0.1:10]
separation = 2.6;   //[2:0.1:10]
coal_height = 5.0;  //[-40:0.1:40]
fill_type = 0; //[0:Level Edges, 1:Tapered, 2:Sculptured, 3:Spare - Flat]

//Bunker sizing
/* [Bunker Size Area:] */
bunker_length = 100; //[1:0.1:300]
bunker_width = 40;  //[1:0.1:200]
enable_radius = false;
radius_to_center = 200;   //[200:1:400]
//rotation_angle = 0; //[5:1:90]

//Trim and Base options
/* [Base Options:] */
internal_fill = true;
base_depth = 20.0;   //[0:0.1:60]
trim_to_size = true;
flat_end_left = false;
flat_end_right = false;
taper_away = false;
taper_distance = 20.0;//[1.0:0.1:60]

//Trim and Base options
/* [Track slot:] */
cut_track_slot=false;
slot_width=90;  //[1:1:200]
slot_depth=5;   //[0:1:60]

//Colours
/* [Colour Options:] */
coal_="Yellow";//[Yellow,grey]
rad_coal_col="Red";//[Red,Yellow,Grey]
taper_coal_col="Tan";//[Tan,Yellow,Grey]

//End of customiser parameters

//Taper
    taper_count = taper_distance/(2 * separation);
    taper_height_step = base_depth/taper_count;
    taper_length=sqrt(base_depth^2+taper_distance^2);
    taper_space=taper_distance/taper_length;
    taper_pillar= 2*separation*taper_space;
    
//echo("TaperCalc",taper_count,taper_height_step,taper_length,taper_space,taper_pillar);

//Rectangle
    half_x_count = bunker_length/(2 * separation);
    half_y_count = bunker_width/(2 * separation);
    cube_pillar = 2 * separation;

//Radius
// arc_len = 2 pi radius (@/360)   @ in Degrees
// arc_len = @ radius              @ in Radians

// x = radius cos @
// y = radius sin @

    arc_radians = bunker_length/radius_to_center;
    arc_degrees = radians_to_degrees(arc_radians);
    
    rad_half_x_count_max = arc_radians * (radius_to_center + (bunker_width/2))/(2 * separation);
    rad_half_x_count_min = arc_radians * (radius_to_center - (bunker_width/2))/(2 * separation);
    rad_half_y_count = bunker_width/(2 * separation);
    rad_half_y_count_max = (radius_to_center+(bunker_width/2))/(2 * separation);
    rad_half_y_count_min = (radius_to_center-(bunker_width/2))/(2 * separation);
    rad_count=arc_radians * (radius_to_center + (bunker_width/2));
    rad_pillar=2*separation;
    
//echo("RadiusCalc",arc_radians,arc_degrees,rad_half_x_count_max,rad_half_x_count_min,rad_half_y_count,rad_half_y_count_min);

function radians_to_degrees(r) = r * 180 / PI;
function degrees_to_radians(d) = d * PI / 180;
function arc_x_point(r,a) = r * cos(a);
function arc_y_point(r,a) = r * sin(a);


//Test functions
/*    for (tf=[-180:10:180]){
        r=degrees_to_radians(tf);
        d=radians_to_degrees(r);
        x=arc_x_point(100,d);
        y=arc_y_point(100,d);
        echo("Deg= ",tf,r,d," Arc xy= ",x,y);
    };
*/
        
function height(X, Y, type=fill_type) =
    (type==0)?   coal_height * ((1-((2 * X / bunker_length)^2)) * (1 - ((2 * Y / bunker_width)^2)))
    :(type==1)? coal_height * ((1 - ((2 * X / bunker_length))) * (1 - ((2 * Y / bunker_width)^2)))
    :(type==2)? coal_height * ((((2 * X / bunker_length)^2)) * ( ((2 * Y / bunker_width)^2)))
    :0              //Spare
    ;

module place_coal_piece(x_count,y_count){
    offsets = rands(-separation/2, separation/2, 3);
          x = x_count * separation;
          y = y_count * separation;
          z = height(x,y);
          ps_2 = cube_pillar/2;
    //echo (3,x,y,z);
          //Generate piece of coal
          translate([x + offsets[0],
                     y + offsets[1],
                     z + offsets[2]])
                        color(coal_) piece_of_coal();
          //Generate base for load to be mounted on
          if(internal_fill==true){
          //echo("PCP_int");
          /*translate([x-separation,y-separation,-base_depth])
          cube([cube_pillar,cube_pillar,z+base_depth]); */
          //
          translate([x-ps_2,y-ps_2,-base_depth])
          cube([cube_pillar,cube_pillar,z+base_depth-cube_pillar]);
          translate([x,y,+z])
          taper_base(ps_2,ps_2,ps_2/2,ps_2/2,cube_pillar);
          //
          }
}

module place_taper_coal_piece(x_count,y_count,z_count,coal_c,pillar_size){
    offsets = rands(-separation/2, separation/2, 3);
          x = x_count * separation;
          y = y_count * separation;
          z = z_count;//height(x,y);
          ps_2 = pillar_size/1.9;
          
    //echo ("T_Values",x,y,z,separation,internal_fill,pillar_size);
          //Generate piece of coal
          translate([x + offsets[0],
                     y + offsets[1],
                     z + offsets[2]])   
                         color(coal_c) piece_of_coal(); 
          //Generate base for load to be mounted on
          if(internal_fill==true){
          //echo("PTCP_int");
          translate([x-ps_2,y-ps_2,-base_depth])
          cube([pillar_size,pillar_size,z+base_depth-pillar_size]);
          translate([x,y,+z])
          taper_base(ps_2,ps_2,ps_2/2,ps_2/2,pillar_size);
          }
}

module taper_base(bx,by,tx,ty,h){
    //Generate rectangular block or taper block
    //    
    CubePoints = [
      [-bx,-by, -h ],  //0
      [ bx,-by, -h ],  //1
      [ bx, by, -h ],  //2
      [-bx, by, -h ],  //3
      [-tx,-ty,  0 ],  //4
      [ tx,-ty,  0 ],  //5
      [ tx, ty,  0 ],  //6
      [-tx, ty,  0 ]]; //7
  
    CubeFaces = [
      [0,1,2,3],  // bottom
      [4,5,1,0],  // front
      [7,6,5,4],  // top
      [5,6,2,1],  // right
      [6,7,3,2],  // back
      [7,4,0,3]]; // left
  
    polyhedron( CubePoints, CubeFaces );
    }

module piece_of_coal(){
    // produces an array of 3 random numbers in the range 0.6 to 1.4, for stretching
    scale_first = rands(0.6, 1.4, 3);  
    scale_second = rands(0.6, 1.4, 3);
    // produces an array of 3 random numbers in the range -90 to 90, for rotating
    rotate_first = rands(-90,90,3);  
    rotate_second = rands(-90,90,3);

    intersection(){
    rotate(rotate_first)scale(scale_first)sphere(coal_size,
        $fn = 5);
    rotate(rotate_second)scale(scale_second)sphere(coal_size,
        $fn = 5);
    }
}

module taper_edges(start_x,start_y,direction,pillar_size){
      //Taper edges - build with bunker
      // 0 4 5 Left
      // 1 6 7 Right
      dir_lup = [[-1,0],[1,0],[0,-1],[0,1],  //L R B T
                 [-1,1],[-1,-1],[1,1],[1,-1]];  //
     
   //echo("Taper",start_x,start_y,direction,dir_lup[direction]);
            if(((flat_end_left==false)&&((direction==0)||(direction==4)||(direction==5)))||((flat_end_right==false)&&((direction==1)||(direction==6)||(direction==7)))||direction==2||direction==3   ){//Flat end check
                for (y_count= [0:taper_space:taper_count]) {
                z_count=(-y_count+taper_count);
                place_taper_coal_piece(start_x+(y_count*dir_lup[direction][0]),start_y+(y_count*dir_lup[direction][1]),(z_count*taper_height_step)-base_depth,taper_coal_col,pillar_size);
                //*** Fill in corner
                  if(direction>=4){
                    for (stagger=[1.1,1.4,2,4,5]){//Stagger
                        place_taper_coal_piece(start_x+(y_count*dir_lup[direction][0]/stagger),start_y+(y_count*dir_lup[direction][1]),(z_count*taper_height_step)-base_depth,taper_coal_col,pillar_size);
                        place_taper_coal_piece(start_x+(y_count*dir_lup[direction][0]),start_y+(y_count*dir_lup[direction][1]/stagger),(z_count*taper_height_step)-base_depth,taper_coal_col,pillar_size);
                    }//Stagger
                  }
                //***
                }
            }
}//End  build with bunker

difference(){
 intersection() {
  union() {
    intersection() {
    //Main area
    echo("Start main");
    if (enable_radius==false){
    //Rectangle
    echo("ProcessRect");
    for (x_count = [-half_x_count:half_x_count]) {
      for (y_count = [-half_y_count:half_y_count]) {
          place_coal_piece(x_count,y_count);
          //echo(x_count,y_count);
          
          if((taper_away == true)&&(trim_to_size == false)) {
            //echo("Start Taper check");
            if(x_count==-half_x_count){taper_edges(x_count,y_count,0,taper_pillar);}   //Left hand edge
            if(x_count+1>=half_x_count){taper_edges(x_count,y_count,1,taper_pillar);}    //Right hand edge
            if(y_count==-half_y_count){taper_edges(x_count,y_count,2,taper_pillar);}   //Bottom edge
            if(y_count+1>=half_y_count){taper_edges(x_count,y_count,3,taper_pillar);}     //Top edge
            
            if((x_count==-half_x_count)&&(y_count+1>=half_y_count)){taper_edges(x_count,y_count,4,taper_pillar);}   //Left top corner
            if((x_count==-half_x_count)&&(y_count==-half_y_count)){taper_edges(x_count,y_count,5,taper_pillar);}   //Left bot corner
            if((x_count+1>=half_x_count)&&(y_count+1>=half_y_count)){taper_edges(x_count,y_count,6,taper_pillar);}    //Right top corner
            if((x_count+1>=half_x_count)&&(y_count==-half_y_count)){taper_edges(x_count,y_count,7,taper_pillar);}    //Right bot corner
          }//End taper_away OK
        }
      }
    } else {
    //Radius
    echo("ProcessRad");
    for (rx_count = [-arc_degrees/2:(arc_degrees/2)/(rad_count/rad_pillar):arc_degrees/2]) {
      for (ry_count = [radius_to_center+(bunker_width/2):-separation:radius_to_center-(bunker_width/2)]) {
          //echo(0,arc_degrees,rad_half_y_count_max,  rx_count,ry_count);
          offy_count= (arc_x_point(ry_count,rx_count)-radius_to_center)/(separation);
          offx_count= arc_y_point(ry_count,rx_count)/(separation);
          //echo(1,offx_count,offy_count);
            place_taper_coal_piece(offx_count,offy_count,0,rad_coal_col,rad_pillar);
            
          if((taper_away == true)&&(trim_to_size == false)) {
            //echo("Start Taper check");
            if(rx_count==-arc_degrees/2){taper_edges(offx_count,offy_count,0,taper_pillar);}   //Left hand edge
            if(rx_count+(arc_degrees/2)/(rad_count/rad_pillar)>=arc_degrees/2){taper_edges(offx_count,offy_count,1,taper_pillar);}    //Right hand edge
            if(ry_count-separation<=radius_to_center-(bunker_width/2)){taper_edges(offx_count,offy_count,2,taper_pillar);}   //Bottom edge 
            if(ry_count==radius_to_center+(bunker_width/2)){taper_edges(offx_count,offy_count,3,taper_pillar);}     //Top edge
            
            if((rx_count==-arc_degrees/2)&&(ry_count==radius_to_center+(bunker_width/2))){taper_edges(offx_count,offy_count,4,taper_pillar);}   //Left top corner
            if((rx_count==-arc_degrees/2)&&(ry_count-separation<=radius_to_center-(bunker_width/2))){taper_edges(offx_count,offy_count,5,taper_pillar);}   //Left bot corner
            if((rx_count+(arc_degrees/2)/(rad_count/rad_pillar)>=arc_degrees/2)&&(ry_count==radius_to_center+(bunker_width/2))){taper_edges(offx_count,offy_count,6,taper_pillar);}    //Right top corner
            if((rx_count+(arc_degrees/2)/(rad_count/rad_pillar)>=arc_degrees/2)&&(ry_count-separation<=radius_to_center-(bunker_width/2))){taper_edges(offx_count,offy_count,7,taper_pillar);}    //Right bot corner
            
          }//End taper_away
          
        }
      }
    }   //If Rectangle/Radius
  // 
               
      //Trim load to bunker size
      if ((trim_to_size == true)&&(enable_radius==false)){ 
        echo("Trim sides to size");
          translate([-bunker_length/2,-bunker_width/2,-base_depth])
          cube([bunker_length, bunker_width, base_depth+100]);
          }

    }   //Intersection
    

     

      
      
  }//Union
  
    //Ensure base for load is flat - issue at small base depth
//*    echo("Trim base");
    translate([-(2*bunker_length+(2*taper_distance)+20)/2,-(2*bunker_width+(2*taper_distance)+20)/2,-base_depth]) 
    cube([(2*bunker_length)+(2*taper_distance), (2*bunker_width)+(2*taper_distance), abs(coal_height)+100]);
    
//*/
 }//Intersection

//Cut routines for flat top areas

    if (cut_track_slot==true){
      echo("Cutting track slot");
      bd_cs=base_depth+coal_size+slot_depth;
      sd_cs=-slot_depth+coal_size;
      if(enable_radius==true){
        difference(){
        translate([0,-radius_to_center,sd_cs]) cylinder(bd_cs,r=radius_to_center+(slot_width/2));
        translate([0,-radius_to_center,sd_cs-1]) cylinder(bd_cs+1,r=radius_to_center-(slot_width/2));
        }
      } else {
        translate([-bunker_length,-slot_width/2,sd_cs]) cube([bunker_length*2,slot_width,bd_cs]);
      }
    }//Cut track slot
     

}//Difference
            
            
echo("Build complete");